/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.helper;

import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.Parent;

public class LookupHelper {
    public static <T extends Node> T lookup(Node node, String ... names) {
        Node current = node;
        if (current == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < names.length; ++i) {
            if ((current = current.lookup(names[i])) != null) continue;
            throw new LookupException(names, i);
        }
        return (T)current;
    }

    public static <T extends Node> Optional<T> lookupIfPossible(Node node, String ... names) {
        Node current = node;
        if (current == null) {
            return Optional.empty();
        }
        for (String name : names) {
            if ((current = current.lookup(name)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(current);
    }

    public static <T extends Node> Point2D getAbsoluteCords(Node child, Node parent) {
        Point2D point2D = new Point2D(0.0, 0.0);
        Parent current = (Parent)child;
        while (current != parent) {
            point2D.x += current.getLayoutX();
            point2D.y += current.getLayoutY();
            if ((current = current.getParent()) != null) continue;
            break;
        }
        return point2D;
    }

    public static class LookupException
    extends RuntimeException {
        public LookupException(String[] stackName, int positionFailed) {
            super(LookupException.buildStack(stackName, positionFailed));
        }

        private static String buildStack(String[] args, int positionFailed) {
            StringBuilder stringBuilder = new StringBuilder("Lookup failed ");
            boolean first = true;
            for (int i = 0; i < args.length; ++i) {
                if (!first) {
                    stringBuilder.append("->");
                }
                stringBuilder.append(args[i]);
                if (i == positionFailed) {
                    stringBuilder.append("(E)");
                }
                first = false;
            }
            return stringBuilder.toString();
        }
    }

    public static class Point2D {
        public double x;
        public double y;

        public Point2D(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

